<?php
/* --------------------------------------------------------------
   UserConfigurationReader.php 2020-02-13
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\UserConfiguration\Repository;

use Doctrine\DBAL\Connection;
use Gambio\Admin\UserConfiguration\Exceptions\UserConfigurationNotFoundException;
use Gambio\Admin\UserConfiguration\Interfaces\UserConfigurationKey;
use Gambio\Admin\UserConfiguration\Interfaces\UserId;

/**
 * Class UserConfigurationReader
 *
 * @package Gambio\Admin\UserConfiguration\Repository#
 */
class UserConfigurationReader
{
    /**
     * @var Connection
     */
    private $db;
    
    
    /**
     * UserConfigurationReader constructor.
     *
     * @param Connection $db
     */
    public function __construct(Connection $db)
    {
        $this->db = $db;
    }
    
    
    /**
     * @param UserId               $userId
     * @param UserConfigurationKey $key
     *
     * @return mixed
     *
     * @throws UserConfigurationNotFoundException
     */
    public function getConfigurationValue(UserId $userId, UserConfigurationKey $key): string
    {
        $data = $this->db->createQueryBuilder()
            ->select('configuration_value')
            ->from('user_configuration')
            ->where('customer_id = :userId AND configuration_key = :key')
            ->setParameter('userId', $userId->userId())
            ->setParameter('key', $key->value())
            ->execute()
            ->fetch();
        
        if ($data === false) {
            throw UserConfigurationNotFoundException::create($userId, $key);
        }
        
        return $data['configuration_value'];
    }
}